/**
 * Tannin constructor.
 *
 * @class
 *
 * @param {TanninLocaleData} data      Jed-formatted locale data.
 * @param {TanninOptions}    [options] Tannin options.
 */
export default function Tannin(data: {
    [domain: string]: {
        [key: string]: TanninDomainMetadata | [string, string];
        '': TanninDomainMetadata | [string, string];
    };
}, options?: TanninOptions): void;
export default class Tannin {
    /**
     * Tannin constructor.
     *
     * @class
     *
     * @param {TanninLocaleData} data      Jed-formatted locale data.
     * @param {TanninOptions}    [options] Tannin options.
     */
    constructor(data: {
        [domain: string]: {
            [key: string]: TanninDomainMetadata | [string, string];
            '': TanninDomainMetadata | [string, string];
        };
    }, options?: TanninOptions);
    /**
     * Jed-formatted locale data.
     *
     * @name Tannin#data
     * @type {TanninLocaleData}
     */
    data: TanninLocaleData;
    /**
     * Plural forms function cache, keyed by plural forms string.
     *
     * @name Tannin#pluralForms
     * @type {Object<string,Function>}
     */
    pluralForms: {
        [x: string]: Function;
    };
    /**
     * Effective options for instance, including defaults.
     *
     * @name Tannin#options
     * @type {TanninOptions}
     */
    options: TanninOptions;
    getPluralForm(domain: string, n: number): number;
    dcnpgettext(domain: string, context: string | void, singular: string, plural?: string, n?: number): string;
}
/**
 * Tannin constructor options.
 */
export type TanninOptions = {
    /**
     * Joiner in string lookup with context.
     */
    contextDelimiter?: string;
    /**
     * Callback to invoke when key missing.
     */
    onMissingKey?: Function;
};
/**
 * Domain metadata.
 */
export type TanninDomainMetadata = {
    /**
     * Domain name.
     */
    domain?: string;
    /**
     * Language code.
     */
    lang?: string;
    /**
     * Plural forms expression or
     *  function evaluator.
     */
    plural_forms?: TimerHandler;
};
/**
 * Domain translation pair respectively representing the singular and plural
 * translation.
 */
export type TanninTranslation = [string, string];
/**
 * Locale data domain. The key is used as reference for lookup, the value an
 * array of two string entries respectively representing the singular and plural
 * translation.
 */
export type TanninLocaleDomain = {
    [key: string]: TanninDomainMetadata | [string, string];
    '': TanninDomainMetadata | [string, string];
};
/**
 * Jed-formatted locale data.
 */
export type TanninLocaleData = {
    [domain: string]: {
        [key: string]: TanninDomainMetadata | [string, string];
        '': TanninDomainMetadata | [string, string];
    };
};
