export default createRunHook;
/**
 * Returns a function which, when invoked, will execute all callbacks
 * registered to a hook of the specified type, optionally returning the final
 * value of the call chain.
 *
 * @param {import('.').Hooks}    hooks                  Hooks instance.
 * @param {import('.').StoreKey} storeKey
 * @param {boolean}              [returnFirstArg=false] Whether each hook callback is expected to
 *                                                      return its first argument.
 *
 * @return {(hookName:string, ...args: unknown[]) => undefined|unknown} Function that runs hook callbacks.
 */
declare function createRunHook(hooks: import('.').Hooks, storeKey: import('.').StoreKey, returnFirstArg?: boolean | undefined): (hookName: string, ...args: unknown[]) => undefined | unknown;
//# sourceMappingURL=createRunHook.d.ts.map